import { FormRawItemController } from '@ibiz-template/controller';
import { FormRawItemModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent } from 'vue';
import '@ibiz-template/theme/style/components/widgets/form/form-raw-item.scss';

export const FormRawItem = defineComponent({
  name: 'FormRawItem',
  props: {
    modelData: {
      type: FormRawItemModel,
      required: true,
    },
    controller: {
      type: FormRawItemController,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('form-raw-item');
    return { ns };
  },
  render() {
    if (!this.controller.visible) {
      return null;
    }
    return <div class={this.ns.b()}>{this.modelData.source.rawContent}</div>;
  },
});

export default FormRawItem;
