import { useNamespace } from '@ibiz-template/vue-util';
import { computed, defineComponent } from 'vue';
import '@ibiz-template/theme/style/components/widgets/form/form-item-container.scss';

export default defineComponent({
  props: {
    required: {
      type: Boolean,
      required: true,
    },
    error: {
      type: String,
    },
    label: {
      type: String,
    },
    labelPos: {
      type: String,
      required: true,
    },
    labelWidth: {
      type: Number,
      required: true,
    },
    inputTip: {
      type: String,
    },
  },
  setup(props) {
    const ns = useNamespace('form-item-container');

    const cssVars = computed(() => {
      if (props.labelWidth !== 130) {
        return ns.cssVarBlock({ 'label-width': `${props.labelWidth}px` });
      }
      return {};
    });
    return { ns, cssVars };
  },
  render() {
    return (
      <div
        class={[
          this.ns.b(),
          this.ns.m(this.labelPos.toLowerCase()),
          this.ns.is('required', this.required),
          this.ns.is('error', !!this.error),
        ]}
        style={this.cssVars}
      >
        <div class={[this.ns.b('content')]}>
          {this.labelPos === 'LEFT' || this.labelPos === 'TOP' ? (
            <div class={[this.ns.e('label')]} title={this.label}>
              {this.inputTip && (
                <i-tooltip
                  content={this.inputTip}
                  transfer-class-name={this.ns.b('input-tip-popper')}
                  class={[this.ns.b('input-tip')]}
                >
                  <ion-icon name='help-circle-outline'></ion-icon>
                </i-tooltip>
              )}
              <span class={[this.ns.em('label', 'text')]}>{this.label}</span>
            </div>
          ) : null}
          <div class={[this.ns.e('editor')]}>{this.$slots.default}</div>

          {this.labelPos === 'RIGHT' || this.labelPos === 'BOTTOM' ? (
            <div class={[this.ns.e('label')]} title={this.label}>
              {this.inputTip && (
                <i-tooltip
                  content={this.inputTip}
                  class={[this.ns.b('input-tip')]}
                  transfer-class-name={this.ns.b('input-tip-popper')}
                >
                  <ion-icon name='help-circle-outline'></ion-icon>
                </i-tooltip>
              )}
              <span class={[this.ns.em('label', 'text')]}>{this.label}</span>
            </div>
          ) : null}
        </div>
        {this.error ? (
          <div class={[this.ns.b('error')]}>{this.error}</div>
        ) : null}
      </div>
    );
  },
});
