import { ContainerPortletController } from '@ibiz-template/controller';
import { ContainerPortletModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, VNode } from 'vue';
import './portlet-container.scss';

export const PortletContainer = defineComponent({
  name: 'PortletContainer',
  props: {
    modelData: {
      type: ContainerPortletModel,
      required: true,
    },
    controller: {
      type: ContainerPortletController,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('portlet-container');
    return { ns };
  },
  render() {
    const defaultSlots: VNode[] = this.$slots.default || [];
    const content = (
      <app-row
        class={this.ns.e('content')}
        layout={this.modelData.source.getPSLayout()}
      >
        {defaultSlots.map(slot => {
          if (!slot.componentOptions) {
            return slot;
          }
          const props = (slot.componentOptions.propsData || {}) as IData;
          return (
            <app-col
              layoutPos={props.modelData.source.getPSLayoutPos()}
              controller={props.controller.layoutController}
            >
              {slot}
            </app-col>
          );
        })}
      </app-row>
    );
    const classArr: string[] = [
      this.ns.b(),
      this.ns.m(this.modelData.modelClass),
    ];
    return (
      <portlet-layout controller={this.controller} class={classArr}>
        {content}
      </portlet-layout>
    );
  },
});
