import { MDViewEngine } from "./md-view-engine";

/**
 * 实体多编辑视图引擎
 *
 * @export
 * @class MEditViewEngine
 * @extends {MDViewEngine}
 */
export class MEditViewEngine extends MDViewEngine {

  /**
   * 多编辑视图面板
   *
   * @type {*}
   * @memberof MEditViewEngine
   */
  public mEditViewPanel: any;

  /**
   * 多编辑视图引擎初始化
   *
   * @param {*} options
   * @memberof MEditViewEngine
   */
  public init(options: any) {
    this.mEditViewPanel = options.meditviewpanel;
    super.init(options);
  }

  /**
   * 部件事件处理
   *
   * @param {string} ctrlName 部件标识
   * @param {string} eventName 事件标识
   * @param {*} args 事件参数
   * @memberof MEditViewEngine
   */
  public onCtrlEvent(ctrlName: string, eventName: string, args: any) {
    if (Object.is(ctrlName, 'meditviewpanel')) {
      this.MDCtrlEvent(eventName, args);
    }
    super.onCtrlEvent(ctrlName, eventName, args);
  }

  public MDCtrlEvent(eventName: string, args: any) {
    if (Object.is(eventName, 'drdatasaved')) {
      this.emitViewEvent('drdatasaved', args);
    }
    if (Object.is(eventName, 'drdatachange')) {
      this.emitViewEvent('drdatachange', args);
    }
    super.MDCtrlEvent(eventName, args);
  }

  /**
   * 获取多编辑视图面板
   *
   * @return {*} 
   * @memberof MEditViewEngine
   */
  public getMDCtrl() {
    return this.mEditViewPanel;
  }

}