import { defineComponent } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import { WFLink } from '@ibiz-template/controller';
import '@ibiz-template/theme/style/components/common/wf-toolbar/wf-toolbar.scss';

export const WFToolbar = defineComponent({
  name: 'WFToolbar',
  props: {
    wfLinks: {
      type: Array<WFLink>,
      required: true,
    },
  },
  setup(props, { emit }) {
    const ns = useNamespace('wf-toolbar');

    // 点击事件抛给表格执行
    const _handleClick = async (link: WFLink, event: MouseEvent) => {
      emit('wf-link-click', link, event);
    };

    // 按钮点击加延时。解决子界面行编辑没有失焦的情况下先触发了按钮的行为。
    const handleClick = async (link: WFLink, event: MouseEvent) => {
      setTimeout(() => {
        _handleClick(link, event);
      }, 30);
    };

    return { ns, handleClick };
  },
  render() {
    const wfLinks = this.wfLinks || [];
    return (
      <div class={`${this.ns.b()}`}>
        {wfLinks.length > 0 &&
          wfLinks.map(link => {
            return (
              <div key={link.sequenceFlowId} class={this.ns.e('item')}>
                <i-button
                  title={link.sequenceFlowName}
                  on-click={(e: MouseEvent) => this.handleClick(link, e)}
                >
                  {link.sequenceFlowName || ''}
                </i-button>
              </div>
            );
          })}
      </div>
    );
  },
});
