import { defineComponent, onMounted } from 'vue';
import { getModelService } from '@ibiz-template/model';
import { IBizContext } from '@ibiz-template/core';
import { toLocalOpenWFRedirectView } from '@ibiz-template/runtime';

export default defineComponent({
  setup() {
    const context = IBizContext.newTempContext(
      {},
      IBizContext.newByIContext(ibiz.appData?.context),
    );

    const { href } = window.location;

    async function toRedirect(): Promise<void> {
      const modelService = await getModelService();

      await toLocalOpenWFRedirectView(modelService, context, href);
    }

    onMounted(() => {
      const el = document.querySelector('.app-loading-x') as HTMLDivElement;
      if (el) {
        el.style.display = 'block';
      }
    });

    toRedirect();
  },
  render() {
    return <div>重定向跳转中</div>;
  },
});
