import { useNamespace, useRoute, useRouter } from '@ibiz-template/vue-util';
import { computed, defineComponent, getCurrentInstance, onMounted } from 'vue';
import '@ibiz-template/theme/style/components/views/404-view/404-view.scss';
import { Route } from 'vue-router';

export default defineComponent({
  setup() {
    const ns = useNamespace('404-view');
    const { proxy } = getCurrentInstance()!;
    const router = useRouter(proxy);
    const route = useRoute(proxy) as Route;
    const gotoIndexView = () => {
      router.push('/');
    };

    onMounted(() => {
      setTimeout(() => {
        const el = document.querySelector('.app-loading-x') as HTMLDivElement;
        if (el) {
          el.style.display = 'none';
        }
      }, 300);
    });

    const isTop = computed(() => {
      return !route.params.view1;
    });

    return { ns, isTop, gotoIndexView };
  },
  render() {
    return (
      <div class={[this.ns.b(), this.ns.is('top', this.isTop)]}>
        <div class={this.ns.e('pic')}>
          <img
            src='./assets/img/404.png'
            alt='404'
            class={this.ns.em('pic', 'parent')}
          />
          <img
            src='./assets/img/404-cloud.png'
            alt='404'
            class={this.ns.em('pic', 'left')}
          />
          <img
            src='./assets/img/404-cloud.png'
            alt='404'
            class={this.ns.em('pic', 'mid')}
          />
          <img
            src='./assets/img/404-cloud.png'
            alt='404'
            class={this.ns.em('pic', 'right')}
          />
        </div>
        <div class={this.ns.b('text')}>
          <div class={this.ns.be('text', 'oops')}>OOPS!</div>
          <div class={this.ns.be('text', 'headline')}>
            The webmaster said that you can not enter this page...
          </div>
          <div class={this.ns.be('text', 'info')}>
            Please check that the URL you entered is correct, or click the
            button below to return to the homepage.
          </div>
          {this.isTop ? (
            <a
              on-click={this.gotoIndexView}
              class={this.ns.be('text', 'return-home')}
            >
              Back to home
            </a>
          ) : null}
        </div>
      </div>
    );
  },
});
