import {
  ContainerPortletController,
  DashboardController,
  HtmlPortletController,
  IPortletPartProvider,
} from '@ibiz-template/controller';
import { HtmlPortletModel, PortletPartModel } from '@ibiz-template/model';

/**
 * 数据看板成员网页部件适配器
 *
 * @author lxm
 * @date 2022-10-19 15:10:44
 * @export
 * @class HtmlPortletProvider
 */
export class HtmlPortletProvider implements IPortletPartProvider {
  component: string = 'PortletPart';

  async createController(
    portletModel: PortletPartModel,
    dashboard: DashboardController,
    parent?: ContainerPortletController,
  ): Promise<HtmlPortletController> {
    const c = new HtmlPortletController(
      portletModel as HtmlPortletModel,
      dashboard,
      parent,
    );
    await c.init();
    return c;
  }
}
