import {
  FormItemController,
  GridEditItemController,
  IEditorProvider,
  SwitchEditorController,
} from '@ibiz-template/controller';
import { SwitchEditorModel } from '@ibiz-template/model';

export class SwitchProvider implements IEditorProvider {
  formEditor: string = 'IBizSwitch';

  gridEditor: string = 'IBizGridSwitch';

  async createController(
    editorModel: SwitchEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<SwitchEditorController> {
    const c = new SwitchEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
