import { RadioButtonListModel } from '@ibiz-template/model';
import { IEditorProvider } from '@ibiz-template/runtime';
import { FormItemController } from '@ibiz-template/controller/src/control/form';
import { GridEditItemController } from '@ibiz-template/controller/src/control/grid';
import { RadioButtonListEditorController } from '@ibiz-template/controller/src/editor';
/**
 * 单选框列表编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class RadioButtonListEditorProvider
 * @implements {EditorProvider}
 */
export class RadioButtonListEditorProvider
  implements IEditorProvider<RadioButtonListEditorController>
{
  formEditor: string = 'IBizRadioButtonList';

  rowEditor: string = 'IBizRadioButtonList';

  async createController(
    editorModel: RadioButtonListModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<RadioButtonListEditorController> {
    const c = new RadioButtonListEditorController(
      editorModel,
      parentController,
    );
    await c.init();
    return c;
  }
}
