import { SpanEditorProvider } from './span-provider';
import { TextBoxEditorProvider } from './text-box-provider';
import { CheckBoxListEditorProvider } from './check-box-list-provider';
import { RadioButtonListEditorProvider } from './radio-button-list-provider';
import { DropDownListEditorProvider } from './drop-down-list-provider';
import { DatePickerEditorProvider } from './date-picker-provider';
import { FileUploaderEditorProvider } from './file-uploader-provider';
import { DataPickerEditorProvider } from './data-picker-provider';

/**
 * 预置默认的编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:50
 * @export
 */
export function presetEditorProvider(): void {
  const { editorRegister } = ibiz.register;
  if (!editorRegister) {
    return;
  }
  // 标签
  editorRegister.register('SPAN', new SpanEditorProvider());

  // 输入框
  const textBoxEditorProvider = new TextBoxEditorProvider();
  editorRegister.register('TEXTBOX', textBoxEditorProvider);
  editorRegister.register('TEXTAREA', textBoxEditorProvider);
  editorRegister.register('TEXTAREA_10', textBoxEditorProvider);
  editorRegister.register('PASSWORD', textBoxEditorProvider);
  editorRegister.register('NUMBER', new TextBoxEditorProvider('NUMBER'));

  // 复选框列表
  editorRegister.register('CHECKBOXLIST', new CheckBoxListEditorProvider());
  // 单选框列表
  editorRegister.register(
    'RADIOBUTTONLIST',
    new RadioButtonListEditorProvider(),
  );
  // 下拉列表
  const dropDownListProvider = new DropDownListEditorProvider();
  editorRegister.register('DROPDOWNLIST', dropDownListProvider);
  editorRegister.register('MDROPDOWNLIST', dropDownListProvider);

  // 日期选择器
  const datePickerProvider = new DatePickerEditorProvider();
  editorRegister.register('DATEPICKER', datePickerProvider);
  editorRegister.register('DATEPICKEREX', datePickerProvider);
  editorRegister.register('DATEPICKEREX_NOTIME', datePickerProvider);
  editorRegister.register('DATEPICKEREX_HOUR', datePickerProvider);
  editorRegister.register('DATEPICKEREX_MINUTE', datePickerProvider);
  editorRegister.register('DATEPICKEREX_SECOND', datePickerProvider);
  editorRegister.register('DATEPICKEREX_NODAY', datePickerProvider);
  editorRegister.register('DATEPICKEREX_NODAY_NOSECOND', datePickerProvider);

  // 文件上传
  editorRegister.register(
    'FILEUPLOADER',
    new FileUploaderEditorProvider('FILEUPLOADER'),
  );
  // 图片上传
  editorRegister.register('PICTURE', new FileUploaderEditorProvider('PICTURE'));

  // 数据选择类
  editorRegister.register('PICKER', new DataPickerEditorProvider('PICKER'));
  editorRegister.register(
    'PICKEREX_NOAC',
    new DataPickerEditorProvider('PICKEREX_NOAC'),
  );
  editorRegister.register(
    'PICKEREX_TRIGGER',
    new DataPickerEditorProvider('PICKEREX_TRIGGER'),
  );
  editorRegister.register(
    'PICKEREX_LINK',
    new DataPickerEditorProvider('PICKEREX_LINK'),
  );
  editorRegister.register(
    'ADDRESSPICKUP',
    new DataPickerEditorProvider('ADDRESSPICKUP'),
  );
}

export {
  SpanEditorProvider,
  TextBoxEditorProvider,
  CheckBoxListEditorProvider,
  RadioButtonListEditorProvider,
  DatePickerEditorProvider,
  FileUploaderEditorProvider,
  DataPickerEditorProvider,
};
