import { IModal } from '@ibiz-template/runtime';
import {
  useWFDynaEditView3Controller,
  useNamespace,
} from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';
import { ViewType } from '@ibiz-template/model';
import { WFLink } from '@ibiz-template/controller';
import { getViewComponentName } from '@/util';

export const WFDynaEditView3 = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useWFDynaEditView3Controller(proxy, props.modelPath);
    const ns = useNamespace(
      `view-${ViewType.DE_WF_DYNA_EDIT_VIEW3}`.toLowerCase(),
    );
    return { c, ns };
  },
  render(h) {
    return (
      <view-base
        controller={this.c}
        scopedSlots={{
          toolbar: () => {
            if (this.c.complete && this.c.model.toolbar) {
              return [
                <view-toolbar
                  modelData={this.c.model.toolbar}
                  on-neuronInit={this.c.nerve.onNeuronInit(
                    this.c.model.toolbar.source.name,
                  )}
                  viewMode={this.c.modal.mode}
                ></view-toolbar>,
                this.c.wfLinks.length > 0 && (
                  <wf-toolbar
                    wfLinks={this.c.wfLinks}
                    on-wf-link-click={(link: WFLink) => {
                      this.c.onLinkClick(link);
                    }}
                  ></wf-toolbar>
                ),
              ];
            }
            return null;
          },
        }}
      >
        {this.c.complete && (
          <i-tabs
            class={[this.ns.be('', 'tab')]}
            name={this.c.model.drTab.source.name}
          >
            <i-tab-pane
              class={this.ns.be('', 'tab-item')}
              tab={this.c.model.drTab.source.name}
              label={this.c.model.drTab.source.editItemCaption}
              name={'mainForm'}
            >
              {this.c.activeForm && (
                <edit-form-control
                  key={this.c.activeForm.id}
                  modelData={this.c.activeForm}
                  context={this.c.context}
                  params={this.c.params}
                  on-neuronInit={this.c.nerve.onNeuronInit('form')}
                ></edit-form-control>
              )}
            </i-tab-pane>
            {[...this.c.model.drTab.pages.values()].map(page => {
              return (
                <i-tab-pane
                  class={this.ns.be('', 'tab-item')}
                  tab={this.c.model.drTab.source.name}
                  disabled={this.c.isNewData}
                  label={page.source.caption}
                  name={page.source.name}
                >
                  {!this.c.isNewData &&
                    h(getViewComponentName(page.embedView.source.viewType), {
                      props: {
                        context: this.c.drPages[page.source.name].context,
                        params: this.c.drPages[page.source.name].params,
                        modal: this.modal,
                        modelPath: page.embedView.source.modelPath,
                        deName: this.c.model.appEntity.source.codeName,
                      },
                      on: {
                        neuronInit: this.c.nerve.onNeuronInit(page.source.name),
                      },
                      key: this.c.drPages[page.source.name].key,
                    })}
                </i-tab-pane>
              );
            })}
          </i-tabs>
        )}
      </view-base>
    );
  },
});
