import { SearchFormModel } from '@ibiz-template/model';
import { useNamespace, useSearchFormController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';
import '@ibiz-template/theme/style/components/widgets/search-form/search-form.scss';

export const SearchFormControl = defineComponent({
  name: 'SearchFormControl',
  props: {
    modelData: {
      type: SearchFormModel,
      required: true,
    },
    context: { type: Object as PropType<IContext>, required: true },
    params: { type: Object as PropType<IParams>, default: () => ({}) },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useSearchFormController(
      proxy,
      props.modelData,
      props.context,
      props.params,
    );
    const ns = useNamespace('search-form');
    return { c, ns };
  },

  render() {
    if (!this.c.complete) {
      return;
    }
    return (
      <div class={this.ns.b()}>
        <form-control
          model-data={this.modelData}
          context={this.context}
          controller={this.c}
          nativeOnkeyup={(e: KeyboardEvent) => this.c.onKeyUp(e)}
        ></form-control>
        <div class={this.ns.b('buttons')}>
          <i-button
            class={this.ns.be('buttons', 'search')}
            on-click={() => this.c.onSearchButtonClick()}
          >
            查询
          </i-button>
          <i-button
            class={this.ns.be('buttons', 'reset')}
            on-click={() => this.c.reset()}
          >
            重置
          </i-button>
        </div>
      </div>
    );
  },
});
export default SearchFormControl;
