import { IModal } from '@ibiz-template/runtime';
import { usePickupViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const PickupView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams>, default: () => ({}) },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = usePickupViewController(proxy, props.modelPath);

    return { c };
  },
  render(h) {
    let panelComponent = null;
    if (this.c.complete) {
      const { pickupViewPanel } = this.c.model;
      if (this.c.providers[pickupViewPanel.name]) {
        panelComponent = h(this.c.providers[pickupViewPanel.name].component, {
          props: {
            modelData: pickupViewPanel,
            context: this.c.context,
            params: this.c.params,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(pickupViewPanel.name),
          },
        });
      }
    }
    return <view-base controller={this.c}>{panelComponent}</view-base>;
  },
});
