import { computed, defineComponent } from 'vue';
import { ViewModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/layout/view-layout/view-layout.scss';

export const ViewLayout = defineComponent({
  name: 'ViewLayout',
  props: {
    modelData: {
      type: ViewModel,
      required: true,
    },
    viewMode: {
      type: String, // ViewMode 类型
      default: 'ROUTE',
    },
    // 视图是否完成加载
    isComplete: {
      type: Boolean,
      default: false,
    },
    isLoading: {
      type: Boolean,
      default: false,
    },
  },
  setup(props) {
    const ns = useNamespace('view-layout');

    // 是否显示头部
    const isShowHeader = computed(() => {
      return props.modelData.source.showCaptionBar || !!props.modelData.toolbar;
    });
    // 是否是编辑视图
    const isEditView = computed(() => {
      return (
        props.modelData?.source?.viewType === 'DEEDITVIEW' ||
        props.modelData?.source?.viewType === 'DEEDITVIE2' ||
        props.modelData?.source?.viewType === 'DEEDITVIEW3' ||
        props.modelData?.source?.viewType === 'DEEDITVIEW4' ||
        props.modelData?.source?.viewType === 'DEWFDYNAEDITVIEW' ||
        props.modelData?.source?.viewType === 'DEWFDYNAEDITVIEW3'
      );
    });

    return { ns, isShowHeader, isEditView };
  },
  render() {
    return !this.isComplete ? (
      <div class={[this.ns.b(), this.ns.m(this.viewMode.toLowerCase())]}>
        {this.isLoading ? <i-spin size='large' fix></i-spin> : null}
      </div>
    ) : (
      <div
        class={[
          this.ns.b(),
          this.ns.m(this.viewMode.toLowerCase()),
          this.ns.is('no-header', !this.isShowHeader),
          this.ns.is('loading', this.isLoading),
        ]}
      >
        {this.isLoading ? <i-spin size='large' fix></i-spin> : null}
        <div class={this.ns.be('top', 'message')}>
          {this.$scopedSlots.topMessage && this.$scopedSlots.topMessage({})}
        </div>
        {this.isShowHeader ? (
          <div key='header' class={this.ns.b('header')}>
            <div class={this.ns.b('header-content')}>
              <div class={this.ns.be('header-content', 'left')}>
                {this.modelData.source.showCaptionBar ? (
                  <div class={this.ns.be('header-content', 'caption')}>
                    {this.$scopedSlots.caption && this.$scopedSlots.caption({})}
                  </div>
                ) : null}
              </div>
              <div class={this.ns.be('header-content', 'right')}>
                <div class={this.ns.e('quick-search')}>
                  {this.$scopedSlots.quickSearch &&
                    this.$scopedSlots.quickSearch({})}
                </div>
                {this.isEditView ? null : (
                  <div class={this.ns.e('toolbar')}>
                    {this.$scopedSlots.toolbar && this.$scopedSlots.toolbar({})}
                  </div>
                )}
              </div>
            </div>
            <div class={this.ns.b('header-exp')}></div>
          </div>
        ) : null}
        {this.$scopedSlots.searchForm && this.$scopedSlots.searchForm({}) && (
          <div key='top' class={this.ns.b('top')}>
            <div class={this.ns.be('top', 'search-form')}>
              {this.$scopedSlots.searchForm && this.$scopedSlots.searchForm({})}
            </div>
          </div>
        )}
        <div key='content' class={this.ns.b('content')}>
          <div class={this.ns.be('content', 'left')}></div>
          <div class={this.ns.be('content', 'body')}>
            <div class={this.ns.be('body', 'message')}>
              {this.$scopedSlots.bodyMessage &&
                this.$scopedSlots.bodyMessage({})}
            </div>
            {this.$scopedSlots.default && this.$scopedSlots.default({})}
          </div>
          <div class={this.ns.be('content', 'right')}></div>
        </div>
        {this.$scopedSlots.footer || this.$scopedSlots.bottomMessage ? (
          <div key='footer' class={this.ns.b('footer')}>
            <div class={this.ns.be('bottom', 'message')}>
              {this.$scopedSlots.bottomMessage &&
                this.$scopedSlots.bottomMessage({})}
            </div>
            {this.$scopedSlots.footer && this.$scopedSlots.footer({})}
          </div>
        ) : null}
        {this.isEditView ? (
          <div class={[this.ns.e('toolbar'), this.ns.e('isedit')]}>
            {this.$scopedSlots.toolbar && this.$scopedSlots.toolbar({})}
          </div>
        ) : null}
      </div>
    );
  },
});
