import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, PropType, ref } from 'vue';
import '@ibiz-template/theme/style/components/common/data-export/data-export.scss';

export const DataExport = defineComponent({
  name: 'DataExport',
  props: {
    dismiss: {
      type: Function as PropType<(_result: IParams) => void>,
      required: true,
    },
    maxRowCount: {
      type: Number,
      required: true,
    },
    pageSize: {
      type: Number,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('data-export');
    const startPage = ref(1);
    const endPage = ref(1);

    const customExport = () => {
      props.dismiss({
        page: 0,
        offset: (startPage.value - 1) * props.pageSize,
        size: (endPage.value - startPage.value + 1) * props.pageSize,
      });
    };

    const exportAll = () => {
      props.dismiss({ page: 0, size: props.maxRowCount });
    };
    const exportCurrent = () => {
      props.dismiss({});
    };

    return {
      ns,
      startPage,
      endPage,
      customExport,
      exportAll,
      exportCurrent,
    };
  },
  render() {
    return (
      <div class={this.ns.b()}>
        <i-button
          class={this.ns.e('text-button')}
          type='text'
          onClick={this.exportAll}
        >
          导出全部（最大导出{this.maxRowCount}行）
        </i-button>
        <i-button
          class={this.ns.e('text-button')}
          type='text'
          onClick={this.exportCurrent}
        >
          导出当前页
        </i-button>
        <div class={this.ns.e('custom-bar')}>
          <i-input-number
            class={this.ns.e('input-number')}
            min={1}
            v-model={this.startPage}
          />
          <span class={this.ns.e('delimiter')}>~</span>
          <i-input-number
            class={this.ns.e('input-number')}
            min={1}
            v-model={this.endPage}
          />
          <span class={this.ns.e('delimiter')}>页</span>
          <i-button
            type='primary'
            disabled={!this.startPage || !this.endPage}
            onClick={this.customExport}
          >
            导出
          </i-button>
        </div>
      </div>
    );
  },
});
