import { defineComponent } from 'vue';
import { ControlModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import '@/styles/components/layout/control-layout/control-layout.scss';

/**
 * 部件布局
 */
export default defineComponent({
  props: {
    modelData: ControlModel,
  },
  setup(props) {
    const ns = useNamespace('control-layout');
    const type = props.modelData?.source.controlType.toLowerCase();

    return { ns, type };
  },
  render() {
    return (
      <div class={{ [this.ns.b()]: true, [this.ns.m(this.type)]: true }}>
        {this.$slots.default}
      </div>
    );
  },
});
