import {
  getGridSwitchProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';
import { defineComponent, h } from 'vue';

export const IBizGridSwitch = defineComponent({
  name: 'IBizGridSwitch',
  props: getGridSwitchProps(),
  setup(props, { emit }) {
    const ns = useNamespace('grid-switch');
    const { isInfoMode, componentRef, autoFocus, onOperateChange, onChange } =
      useGridCellEditor(props, { emit });
    return {
      ns,
      isInfoMode,
      autoFocus,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render() {
    return (
      <grid-editor
        disabled={this.disabled}
        readonly={this.readonly}
        ref='componentRef'
        class={this.ns.b()}
      >
        {h('IBizSwitch', {
          props: {
            ...this.$props,
            readonly: this.isInfoMode,
            disabled: this.disabled,
            autoFocus: this.autoFocus,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </grid-editor>
    );
  },
});
