import { RawMaterialBaseService } from './raw-material-base.service';

/**
 * 原材料服务
 *
 * @export
 * @class RawMaterialService
 * @extends {RawMaterialBaseService}
 */
export class RawMaterialService extends RawMaterialBaseService {
    /**
     * Creates an instance of RawMaterialService.
     * @memberof RawMaterialService
     */
    constructor(opts?: any) {
        const { context: context, tag: cacheKey } = opts;
        super(context);
        if (___ibz___.sc.has(cacheKey)) {
            return ___ibz___.sc.get(cacheKey);
        }
        ___ibz___.sc.set(cacheKey, this);
    }

    /**
     * 获取实例
     *
     * @static
     * @param 应用上下文
     * @return {*}  {RawMaterialService}
     * @memberof RawMaterialService
     */
    static getInstance(context?: any): RawMaterialService {
        const cacheKey: string = context?.srfdynainstid ? `${context.srfdynainstid}RawMaterialService` : `RawMaterialService`;
        if (!___ibz___.sc.has(cacheKey)) {
            new RawMaterialService({ context: context, tag: cacheKey });
        }
        return ___ibz___.sc.get(cacheKey);
    }
}
export default RawMaterialService;
