import { CodeListService } from '../app/codelist-service';
import { EntityBaseService, IContext, HttpResponse } from 'ibiz-core';
import { GlobalService } from '../global.service';
import { IRawMaterial, RawMaterial } from '../../entities';
import keys from '../../entities/raw-material/raw-material-keys';
import { RawMaterialDTOHelp } from '../../entities/raw-material/raw-material-dto-help';


/**
 * 原材料服务对象基类
 *
 * @export
 * @class RawMaterialBaseService
 * @extends {EntityBaseService}
 */
export class RawMaterialBaseService extends EntityBaseService<IRawMaterial> {
    protected get keys(): string[] {
        return keys;
    }
    protected SYSTEMNAME = 'TrainSys';
    protected APPNAME = 'Web';
    protected APPDENAME = 'RawMaterial';
    protected APPWFDENAME = 'RAWMATERIAL';
    protected APPDENAMEPLURAL = 'RawMaterials';
    protected dynaModelFilePath:string = 'PSSYSAPPS/Web/PSAPPDATAENTITIES/RawMaterial.json';
    protected APPDEKEY = 'rawmaterialid';
    protected APPDETEXT = 'rawmaterialname';
    protected quickSearchFields = ['rawmaterialname',];
    protected selectContextParam = {
    };

    constructor(opts?: any) {
        super(opts, 'RawMaterial');
    }

    newEntity(data: IRawMaterial): RawMaterial {
        return new RawMaterial(data);
    }

    /**
     * Create
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof RawMaterialService
     */
    async Create(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        _data = await this.beforeExecuteAction(_context,_data,'Create');
        if (!_data.srffrontuf || _data.srffrontuf != 1) {
            _data[this.APPDEKEY] = null;
        }
        if (_data.srffrontuf != null) {
            delete _data.srffrontuf;
        }
        _data = await RawMaterialDTOHelp.get(_context,_data);
        const res = await this.http.post(`/rawmaterials`, _data);
        res.data = await RawMaterialDTOHelp.set(_context,res.data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Get
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof RawMaterialService
     */
    async Get(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.get(`/rawmaterials/${encodeURIComponent(_context.rawmaterial)}`, _data);
        res.data = await RawMaterialDTOHelp.set(_context,res.data);
        res.data = await this.afterExecuteAction(_context,res?.data,'Get');
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * GetDraft
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof RawMaterialService
     */
    async GetDraft(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        _data[this.APPDENAME?.toLowerCase()] = undefined;
        _data[this.APPDEKEY] = undefined;
        const res = await this.http.get(`/rawmaterials/getdraft`, _data);
        res.data = await RawMaterialDTOHelp.set(_context,res.data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Remove
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof RawMaterialService
     */
    async Remove(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.delete(`/rawmaterials/${encodeURIComponent(_context.rawmaterial)}`, _data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Update
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof RawMaterialService
     */
    async Update(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        _data = await this.beforeExecuteAction(_context,_data,'Update');
        _data = await RawMaterialDTOHelp.get(_context,_data);
        const res = await this.http.put(`/rawmaterials/${encodeURIComponent(_context.rawmaterial)}`, _data);
        res.data = await RawMaterialDTOHelp.set(_context,res.data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * FetchDefault
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof RawMaterialService
     */
    async FetchDefault(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.post(`/rawmaterials/fetchdefault`, _data);
        res.data = await RawMaterialDTOHelp.ToDataObjArray(_context,res.data);
        res.data = await this.afterExecuteActionBatch(_context,res?.data,'FetchDefault');
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Select
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof RawMaterialService
     */
    async Select(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.post(`/rawmaterials/select`, _data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
}
