import { EntityBase } from 'ibiz-core';
import { IRawMaterial } from '../interface';

/**
 * 原材料基类
 *
 * @export
 * @abstract
 * @class RawMaterialBase
 * @extends {EntityBase}
 * @implements {IRawMaterial}
 */
export abstract class RawMaterialBase extends EntityBase implements IRawMaterial {
    /**
     * 实体名称
     *
     * @readonly
     * @type {string}
     * @memberof RawMaterialBase
     */
    get srfdename(): string {
        return 'RAWMATERIAL';
    }
    get srfkey() {
        return this.rawmaterialid;
    }
    set srfkey(val: any) {
        this.rawmaterialid = val;
    }
    get srfmajortext() {
        return this.rawmaterialname;
    }
    set srfmajortext(val: any) {
        this.rawmaterialname = val;
    }
    /**
     * 原材料标识
     */
    rawmaterialid?: any;
    /**
     * 建立时间
     */
    createdate?: any;
    /**
     * 原材料名称
     */
    rawmaterialname?: any;
    /**
     * 建立人
     */
    createman?: any;
    /**
     * 更新时间
     */
    updatedate?: any;
    /**
     * 更新人
     */
    updateman?: any;

    /**
     * 重置实体数据
     *
     * @private
     * @param {*} [data={}]
     * @memberof RawMaterialBase
     */
    reset(data: any = {}): void {
        super.reset(data);
        this.rawmaterialid = data.rawmaterialid || data.srfkey;
        this.rawmaterialname = data.rawmaterialname || data.srfmajortext;
    }
}
