import { GridViewEngine } from './grid-view-engine';

/**
 * 实体选择表格视图（部件视图）界面引擎
 *
 * @export
 * @class PickupGridViewEngine
 * @extends {GridViewEngine}
 */
export class PickupGridViewEngine extends GridViewEngine {

    /**
     * 选中激活数据
     *
     * @param {string} eventName
     * @param {*} args
     * @memberof PickupGridViewEngine
     */
    public MDCtrlEvent(eventName: string, args: any): void {
        if (Object.is(eventName, 'rowdblclick') && this.gridRowAllowActive(2)) {
            this.emitViewEvent('viewdatasactivated', args);
            return;
        }
        super.MDCtrlEvent(eventName, args);
    }

    /**
     * 选择全部
     *
     * @memberof PickupGridViewEngine
     */
    public selectAll() {
        const grid = this.getMDCtrl();
        if (grid && grid.items && grid.items.length && grid.$refs[grid.realCtrlRefName]) {
            if (grid.items.findIndex((item: any) => item.srfchecked !== 1) !== -1) {
                grid.$refs[grid.realCtrlRefName].toggleAllSelection();
            }
        }
    }
}