import { ControlService } from '@ibiz-template/service';
import { IHttpResponse } from '@ibiz-template/core';
import { ChartModel, IPSDEChartSeries } from '@ibiz-template/model';
import { DatasetComponentOption, EChartsOption, SeriesOption } from 'echarts';
import { CodeListMap } from '../interface/code-list-map';
/**
 * 图表服务
 *
 * @author zhanghengfeng
 * @date 2023-04-03 16:04:23
 * @export
 * @class ChartService
 * @extends {ControlService<ChartModel>}
 */
export declare class ChartService extends ControlService<ChartModel> {
    /**
     * 序列列表
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:38
     * @type {IPSDEChartSeries[]}
     */
    seriesList: IPSDEChartSeries[];
    constructor(model: ChartModel);
    /**
     * 获取数据
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:11
     * @param {IContext} context
     * @param {IParams} [params={}]
     * @return {*}  {Promise<IHttpResponse>}
     */
    fetch(context: IContext, params?: IParams): Promise<IHttpResponse>;
    /**
     * 获取所有代码表映射
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:21
     * @param {IContext} context
     * @param {IParams} params
     * @return {*}
     */
    getAllCodeListMap(context: IContext, params: IParams): Promise<CodeListMap[]>;
    /**
     * 生成数据集配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:37
     * @param {IPSDEChartSeries} series
     * @param {IData[]} data
     * @param {CodeListMap} map
     * @return {*}
     */
    generateDatasetOption(series: IPSDEChartSeries, data: IData[], map: CodeListMap): DatasetComponentOption;
    /**
     * 生成图表配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:49
     * @param {IData[]} data
     * @param {IContext} context
     * @param {IParams} params
     * @return {*}
     */
    generateChartOption(data: IData[], context: IContext, params: IParams): Promise<EChartsOption>;
    /**
     * 生成柱状图序列配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:13
     * @param {IPSDEChartSeries} series
     * @param {IData[]} data
     * @param {CodeListMap} map
     * @param {number} index
     * @return {*}
     */
    generateBarSeriesOption(series: IPSDEChartSeries, data: IData[], map: CodeListMap, index: number): SeriesOption[];
    /**
     * 生成折线图序列配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:32
     * @param {IPSDEChartSeries} series
     * @param {IData[]} data
     * @param {CodeListMap} map
     * @param {number} index
     * @return {*}
     */
    generateLineSeriesOption(series: IPSDEChartSeries, data: IData[], map: CodeListMap, index: number): SeriesOption[];
    /**
     * 生成饼图序列配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:44
     * @param {IPSDEChartSeries} series
     * @param {IData[]} data
     * @param {CodeListMap} map
     * @param {number} index
     * @return {*}
     */
    generatePieSeriesOption(series: IPSDEChartSeries, data: IData[], map: CodeListMap, index: number): SeriesOption[];
    /**
     * 生成漏斗图序列配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:03
     * @param {IPSDEChartSeries} series
     * @param {IData[]} data
     * @param {CodeListMap} map
     * @param {number} index
     * @return {*}
     */
    generateFunnelSeriesOption(series: IPSDEChartSeries, data: IData[], map: CodeListMap, index: number): SeriesOption[];
    /**
     * 生成散点图序列配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:25
     * @param {IPSDEChartSeries} series
     * @param {IData[]} data
     * @param {CodeListMap} map
     * @param {number} index
     * @return {*}
     */
    generateScatterSeriesOption(series: IPSDEChartSeries, data: IData[], map: CodeListMap, index: number): SeriesOption[];
    /**
     * 生成雷达图序列配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:47
     * @param {IPSDEChartSeries} series
     * @param {IData[]} data
     * @param {CodeListMap} map
     * @return {*}
     */
    generateRadarSeriesOption(series: IPSDEChartSeries, data: IData[], map: CodeListMap): {
        series: SeriesOption[];
        radar: {
            indicator: {
                name: string;
                max: number;
            }[];
        };
    };
}
