import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router';
import { AppServiceBase } from 'ibiz-core';
import { AppNavHistory, AppViewShell,AppIndexViewShell } from 'ibiz-vue';
Vue.use(Router);

const router = new Router({
    routes: [
        {
            path: '/appindex/:appindex?',
            beforeEnter: (to: any, from: any, next: any) => {
                const routerParamsName = 'appindex';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    Object.assign(params, qs.parse(to.params[routerParamsName], { delimiter: ';' }));
                }
                const url: string = '/appdata';
                const auth: Promise<any> = AuthGuard.getInstance().authGuard(url, params, router);
                auth.then((result) => {
                    next(result ? true : false);
                }).catch(() => {
                    next(false);
                });
            },
            meta: {  
                captionTag: '',
                caption: '首页',
                info:'',
                viewType: 'APPINDEX',
                dynaModelFilePath:'PSSYSAPPS/Web/PSAPPINDEXVIEWS/AppIndex.json',
                parameters: [
                    { pathName: 'views', parameterName: 'appindex' },
                ],
                requireAuth: false,
            },
            component: AppIndexViewShell,
            children: [
                    {
                    path: 'phones/:phone?/views/:view?',
                    meta: {
                        captionTag: '',
                        caption: '',
                        info:'',
                        imgPath: '',
                        iconCls: '',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'phones', parameterName: 'phone' },
                            { pathName: 'views', parameterName: 'view' },
                        ],
                        resource:'phone',
                        requireAuth: false,
                    },
                    component: AppViewShell
                    },
                    {
                    path: 'rawmaterials/:rawmaterial?/views/:view?',
                    meta: {
                        captionTag: '',
                        caption: '',
                        info:'',
                        imgPath: '',
                        iconCls: '',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'rawmaterials', parameterName: 'rawmaterial' },
                            { pathName: 'views', parameterName: 'view' },
                        ],
                        resource:'rawmaterial',
                        requireAuth: false,
                    },
                    component: AppViewShell
                    },
                    {
                    path: 'books/:book?/views/:view?',
                    meta: {
                        captionTag: '',
                        caption: '',
                        info:'',
                        imgPath: '',
                        iconCls: '',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'books', parameterName: 'book' },
                            { pathName: 'views', parameterName: 'view' },
                        ],
                        resource:'book',
                        requireAuth: false,
                    },
                    component: AppViewShell
                    },
                    {
                    path: 'reginfos/:reginfo?/views/:view?',
                    meta: {
                        captionTag: '',
                        caption: '',
                        info:'',
                        imgPath: '',
                        iconCls: '',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'reginfos', parameterName: 'reginfo' },
                            { pathName: 'views', parameterName: 'view' },
                        ],
                        resource:'reginfo',
                        requireAuth: false,
                    },
                    component: AppViewShell
                    },
            {
                path: 'views/:view?',
                meta: {
                    captionTag: '',
                    caption: '',
                    info:'',
                    imgPath: '',
                    iconCls: '',
                    parameters: [
                        { pathName: 'appindex', parameterName: 'appindex' },
                        { pathName: 'views', parameterName: 'view' },
                    ],
                    requireAuth: false,
                },
                component: AppViewShell,
            },
            {
                path: 'appredirectview',
                meta: {
                    captionTag: '',  
                    caption: '全局应用重定向视图',
                    viewType: 'REDIRECTVIEW',
                    requireAuth: false,
                    ignoreAddPage: true,
                    parameters: [
                      { pathName: 'appredirectview', parameterName: 'appredirectview' },
                      { pathName: 'views', parameterName: 'view' },
                    ],
                },
                component: () => import('@components/app-redirect-view/app-redirect-view.vue'),
            },
            ...indexRoutes,
            ],
        },
        ...globalRoutes,
        {
            path: '/login/:login?',
            name: 'login',
            meta: {
                captionTag: '',
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                router.app.$store.commit('resetRootStateData');
                next();
            },
            component: () => import('@components/login/login.vue'),
        },
        {
            path: '/lock',
            name: 'lock',
            meta: {  
                captionTag: '',
                caption: '锁屏',
                viewType: 'lock',
                requireAuth: false,
                ignoreAddPage: true,
            },
            component: () => import('@components/app-lock/app-lock.vue'),
        },
        {
            path: '/appredirectview',
            name: 'appredirectview',
            meta: {
                captionTag: '',  
                caption: '全局应用重定向视图',
                viewType: 'REDIRECTVIEW',
                requireAuth: false,
                ignoreAddPage: true,
            },
            component: () => import('@components/app-redirect-view/app-redirect-view.vue'),
        },
        {
            path: '/todoredirect',
            name: 'todoredirect',
            meta: {
                captionTag: '',  
                caption: '全局待办重定向视图',
                viewType: 'REDIRECTVIEW',
                requireAuth: false,
                ignoreAddPage: true,
            },
            component: () => import('@components/todo-redirect/todo-redirect.vue'),
        },
        {
            path: '/404',
            meta: {  
                caption: '404',
                ignoreAddPage: true,
                requireAuth: false
            },
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            meta: {  
                caption: '500',
                ignoreAddPage: true,
                requireAuth: false
            },
            component: () => import('@components/500/500.vue')
        },
        {
            path: '/appsharepage',
            meta: {
                caption: '应用分享页',
                requireAuth: true,
                ignoreAddPage: true
            },
            component: () => import('@components/app-share-page/app-share-page.vue')
        },
        {
            path: '*',
            redirect: 'appindex'
        },
    ],
});

// 解决路由跳转路由重复时报错
const originalPush = Router.prototype.push
Router.prototype.push = function push(location: any) {
    let result: any = originalPush.call(this, location);
    return result.catch((err: any) => err);
}
export default router;