import { PhoneUIServiceBase } from './phone-ui-service-base';

/**
 * 手机UI服务对象
 *
 * @export
 * @class PhoneUIService
 */
export default class PhoneUIService extends PhoneUIServiceBase {

    /**
     * 基础UI服务实例
     * 
     * @private
     * @type {ORDER1UIServiceBase}
     * @memberof PhoneUIService
     */
    private static basicUIServiceInstance: PhoneUIService;

    /**
     * 动态模型服务存储Map对象
     *
     * @private
     * @type {Map<string, any>}
     * @memberof PhoneUIService
     */
    private static UIServiceMap: Map<string, any> = new Map();

    /**
     * Creates an instance of  PhoneUIService.
     * 
     * @param {*} [opts={}]
     * @memberof  PhoneUIService
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 通过应用上下文获取实例对象
     *
     * @public
     * @memberof PhoneUIService
     */
    public static getInstance(context: any): PhoneUIService {
        if (!this.basicUIServiceInstance) {
            this.basicUIServiceInstance = new PhoneUIService({context:context});
        }
        if (!context.srfdynainstid) {
            return this.basicUIServiceInstance;
        } else {
            if (!PhoneUIService.UIServiceMap.get(context.srfdynainstid)) {
                PhoneUIService.UIServiceMap.set(context.srfdynainstid, new PhoneUIService({context:context}));
            }
            return PhoneUIService.UIServiceMap.get(context.srfdynainstid);
        }
    }

}