import { BookUIServiceBase } from './book-ui-service-base';

/**
 * 书UI服务对象
 *
 * @export
 * @class BookUIService
 */
export default class BookUIService extends BookUIServiceBase {

    /**
     * 基础UI服务实例
     * 
     * @private
     * @type {ORDER1UIServiceBase}
     * @memberof BookUIService
     */
    private static basicUIServiceInstance: BookUIService;

    /**
     * 动态模型服务存储Map对象
     *
     * @private
     * @type {Map<string, any>}
     * @memberof BookUIService
     */
    private static UIServiceMap: Map<string, any> = new Map();

    /**
     * Creates an instance of  BookUIService.
     * 
     * @param {*} [opts={}]
     * @memberof  BookUIService
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 通过应用上下文获取实例对象
     *
     * @public
     * @memberof BookUIService
     */
    public static getInstance(context: any): BookUIService {
        if (!this.basicUIServiceInstance) {
            this.basicUIServiceInstance = new BookUIService({context:context});
        }
        if (!context.srfdynainstid) {
            return this.basicUIServiceInstance;
        } else {
            if (!BookUIService.UIServiceMap.get(context.srfdynainstid)) {
                BookUIService.UIServiceMap.set(context.srfdynainstid, new BookUIService({context:context}));
            }
            return BookUIService.UIServiceMap.get(context.srfdynainstid);
        }
    }

}