import { PhoneBaseService } from './phone-base.service';

/**
 * 手机服务
 *
 * @export
 * @class PhoneService
 * @extends {PhoneBaseService}
 */
export class PhoneService extends PhoneBaseService {
    /**
     * Creates an instance of PhoneService.
     * @memberof PhoneService
     */
    constructor(opts?: any) {
        const { context: context, tag: cacheKey } = opts;
        super(context);
        if (___ibz___.sc.has(cacheKey)) {
            return ___ibz___.sc.get(cacheKey);
        }
        ___ibz___.sc.set(cacheKey, this);
    }

    /**
     * 获取实例
     *
     * @static
     * @param 应用上下文
     * @return {*}  {PhoneService}
     * @memberof PhoneService
     */
    static getInstance(context?: any): PhoneService {
        const cacheKey: string = context?.srfdynainstid ? `${context.srfdynainstid}PhoneService` : `PhoneService`;
        if (!___ibz___.sc.has(cacheKey)) {
            new PhoneService({ context: context, tag: cacheKey });
        }
        return ___ibz___.sc.get(cacheKey);
    }
}
export default PhoneService;
