import { CodeListService } from '../app/codelist-service';
import { EntityBaseService, IContext, HttpResponse } from 'ibiz-core';
import { GlobalService } from '../global.service';
import { IPhone, Phone } from '../../entities';
import keys from '../../entities/phone/phone-keys';
import { PhoneDTOHelp } from '../../entities/phone/phone-dto-help';


/**
 * 手机服务对象基类
 *
 * @export
 * @class PhoneBaseService
 * @extends {EntityBaseService}
 */
export class PhoneBaseService extends EntityBaseService<IPhone> {
    protected get keys(): string[] {
        return keys;
    }
    protected SYSTEMNAME = 'TrainSys';
    protected APPNAME = 'Web';
    protected APPDENAME = 'Phone';
    protected APPWFDENAME = 'PHONE';
    protected APPDENAMEPLURAL = 'Phones';
    protected dynaModelFilePath:string = 'PSSYSAPPS/Web/PSAPPDATAENTITIES/Phone.json';
    protected APPDEKEY = 'phoneid';
    protected APPDETEXT = 'phonename';
    protected quickSearchFields = ['phonename',];
    protected selectContextParam = {
    };

    constructor(opts?: any) {
        super(opts, 'Phone');
    }

    newEntity(data: IPhone): Phone {
        return new Phone(data);
    }

    /**
     * Create
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof PhoneService
     */
    async Create(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        _data = await this.beforeExecuteAction(_context,_data,'Create');
        if (!_data.srffrontuf || _data.srffrontuf != 1) {
            _data[this.APPDEKEY] = null;
        }
        if (_data.srffrontuf != null) {
            delete _data.srffrontuf;
        }
        _data = await PhoneDTOHelp.get(_context,_data);
        const res = await this.http.post(`/phones`, _data);
        res.data = await PhoneDTOHelp.set(_context,res.data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Get
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof PhoneService
     */
    async Get(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.get(`/phones/${encodeURIComponent(_context.phone)}`, _data);
        res.data = await PhoneDTOHelp.set(_context,res.data);
        res.data = await this.afterExecuteAction(_context,res?.data,'Get');
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * GetDraft
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof PhoneService
     */
    async GetDraft(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        _data[this.APPDENAME?.toLowerCase()] = undefined;
        _data[this.APPDEKEY] = undefined;
        const res = await this.http.get(`/phones/getdraft`, _data);
        res.data = await PhoneDTOHelp.set(_context,res.data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Remove
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof PhoneService
     */
    async Remove(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.delete(`/phones/${encodeURIComponent(_context.phone)}`, _data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Update
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof PhoneService
     */
    async Update(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        _data = await this.beforeExecuteAction(_context,_data,'Update');
        _data = await PhoneDTOHelp.get(_context,_data);
        const res = await this.http.put(`/phones/${encodeURIComponent(_context.phone)}`, _data);
        res.data = await PhoneDTOHelp.set(_context,res.data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * FetchDefault
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof PhoneService
     */
    async FetchDefault(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.post(`/phones/fetchdefault`, _data);
        res.data = await PhoneDTOHelp.ToDataObjArray(_context,res.data);
        res.data = await this.afterExecuteActionBatch(_context,res?.data,'FetchDefault');
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
    /**
     * Select
     *
     * @param {*} [_context={}]
     * @param {*} [_data = {}]
     * @returns {Promise<HttpResponse>}
     * @memberof PhoneService
     */
    async Select(_context: any = {}, _data: any = {}): Promise<HttpResponse> {
        try {
        const res = await this.http.post(`/phones/select`, _data);
        return res;
            } catch (error) {
                return this.handleResponseError(error);
            }
    }
}
