import { defineComponent } from 'vue';
import {
  getGridEditorEmits,
  getGridInputProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridCheckbox = defineComponent({
  name: 'IBizGridCheckbox',
  props: getGridInputProps(),
  emits: getGridEditorEmits(),
  setup(props, { emit }) {
    const ns = useNamespace('grid-checkbox');
    const { isInfoMode, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props, { emit });

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <grid-editor
        disabled={this.disabled}
        readonly={this.readonly}
        ref='componentRef'
        class={`${this.ns.b()}`}
      >
        {h('IBizCheckbox', {
          props: {
            ...this.$props,
            readonly: this.isInfoMode,
            disabled: this.disabled,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </grid-editor>
    );
  },
});
