import {
  IGridColumnProvider,
  GridController,
  GridFieldEditColumnController,
} from '@ibiz-template/controller';
import { GridFieldColumnModel } from '@ibiz-template/model';
/**
 * 表格属性列(开启行编辑)适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class GridFieldEditColumnProvider
 * @implements {IGridColumnProvider}
 */
export class GridFieldEditColumnProvider implements IGridColumnProvider {
  component: string = 'GridFieldEditColumn';

  async createController(
    columnModel: GridFieldColumnModel,
    grid: GridController,
  ): Promise<GridFieldEditColumnController> {
    const c = new GridFieldEditColumnController(columnModel, grid);
    await c.init();
    return c;
  }
}
