import G, { defineComponent as S, ref as q, h as e, getCurrentInstance as z } from "vue";
import { useNamespace as H } from "@ibiz-template/vue-util";
import { ChartModel as B } from "@ibiz-template/model";
import { mergeDeepRight as N } from "ramda";
import { u as J } from "./use-chart-controller-d5d0d5a1.js";
import "@ibiz-template/controller";
import "qx-util";
import "echarts";
import "@ibiz-template/service";
const V = S({
  name: "ChartTooltip",
  props: {
    params: {
      type: [Object, Array],
      required: !0
    },
    c: {
      type: Object,
      required: !0
    },
    codeListMap: {
      type: Array,
      required: !0
    }
  },
  setup(t) {
    var r;
    const k = H("chart-tooltip"), g = q([]), l = q(""), c = q(), u = ((r = t.c.model.source.getPSControlParam()) == null ? void 0 : r.ctrlParams) || {}, x = u.LABEL, T = u.TEXT, F = u.LEFT, I = u.CENTER, E = u.RIGHT, n = u.PERCENTAGE, $ = u.RATE, o = JSON.parse(u.LIST || "[]"), b = (s) => {
      if (s == null)
        return "";
      try {
        return ibiz.util.text.format(`${s}`, "#,##0");
      } catch (a) {
        return ibiz.log.error(`${s} 值格式化错误`), `${s}`;
      }
    };
    return (() => {
      var a, m, p, L, C, M, w, R;
      const s = t.params;
      if (Array.isArray(s))
        g.value = s.map((i) => {
          var v, d;
          if (!c.value && Array.isArray(t.c.items) && t.c.items.length) {
            const f = i.seriesIndex || 0, D = t.c.service.seriesList[f], y = (v = D == null ? void 0 : D.catalogField) == null ? void 0 : v.toLowerCase(), A = i.name || "", h = (d = t.codeListMap[f]) == null ? void 0 : d.catalog;
            y && A && (c.value = t.c.items.find((j) => h && h.get(j[y]) ? h.get(j[y]) === A : j[y] === A));
          }
          l.value = i.name || "";
          const P = Array.isArray(i.value) ? i.value[1] : i.value;
          return {
            text: i.seriesName,
            value: b(P),
            color: i.color
          };
        }), Array.isArray(o) && o.length && (g.value = o.map((i) => {
          var v, d;
          const P = (v = c.value) == null ? void 0 : v[i.value];
          return {
            color: i.color,
            text: i.text,
            value: b(P),
            rate: (d = c.value) == null ? void 0 : d[i.rate]
          };
        }));
      else if (s) {
        const i = s;
        if (Array.isArray(t.c.items) && t.c.items.length) {
          const v = i.seriesIndex || 0, d = t.c.service.seriesList[v], f = (a = d == null ? void 0 : d.catalogField) == null ? void 0 : a.toLowerCase(), D = (m = d == null ? void 0 : d.valueField) == null ? void 0 : m.toLowerCase();
          if (i.seriesType === "radar") {
            g.value = t.c.items.map((h) => ({
              text: h[f],
              value: b(h[D]),
              color: i.color,
              left: F,
              center: h[I],
              right: E
            })), c.value = {};
            return;
          }
          const y = i.name || "", A = (p = t.codeListMap[v]) == null ? void 0 : p.catalog;
          f && y && (c.value = t.c.items.find((h) => A && A.get(h[f]) ? A.get(h[f]) === y : h[f] === y));
        }
        const P = Array.isArray(i.value) ? (L = i.value) == null ? void 0 : L[1] : i.value;
        g.value = [{
          text: ((C = c.value) == null ? void 0 : C[T]) || s.name,
          value: b(P),
          color: i.color,
          left: F,
          center: (M = c.value) == null ? void 0 : M[I],
          right: E,
          percentage: (w = c.value) == null ? void 0 : w[n],
          rate: (R = c.value) == null ? void 0 : R[$]
        }];
      }
    })(), {
      ns: k,
      title: l,
      items: g,
      curData: c,
      label: x
    };
  },
  render() {
    if (this.curData)
      return e("div", {
        class: this.ns.b()
      }, [this.label && this.curData[this.label] && e("div", {
        class: this.ns.b("header")
      }, [this.curData[this.label]]), !(this.label && this.curData[this.label]) && this.title && e("div", {
        class: this.ns.b("header")
      }, [this.title]), e("div", {
        class: this.ns.b("content")
      }, [e("div", {
        class: this.ns.b("item-icon")
      }, [this.items.map((t) => e("div", {
        class: this.ns.b("item")
      }, [t.color && e("div", {
        class: this.ns.be("item", "icon"),
        style: {
          background: t.color
        }
      })]))]), e("div", {
        class: this.ns.b("item-text")
      }, [this.items.map((t) => e("div", {
        class: this.ns.b("item")
      }, [t.text && e("div", {
        class: this.ns.be("item", "text")
      }, [t.text])]))]), e("div", {
        class: this.ns.b("item-value")
      }, [this.items.map((t) => e("div", {
        class: this.ns.b("item")
      }, [t.value != null && e("div", {
        class: this.ns.be("item", "value")
      }, [t.value])]))]), e("div", {
        class: this.ns.b("item-center")
      }, [this.items.map((t) => e("div", {
        class: this.ns.b("item")
      }, [t.left && e("div", {
        class: this.ns.be("item", "left")
      }, [t.left]), t.center != null && e("div", {
        class: this.ns.be("item", "center")
      }, [t.center]), t.right && e("div", {
        class: this.ns.be("item", "right")
      }, [t.right])]))]), e("div", {
        class: this.ns.b("item-percentage")
      }, [this.items.map((t) => e("div", {
        class: this.ns.b("item")
      }, [t.percentage && e("div", {
        class: this.ns.be("item", "percentage")
      }, [t.percentage])]))]), e("div", {
        class: this.ns.b("item-rate")
      }, [this.items.map((t) => e("div", {
        class: this.ns.b("item")
      }, [t.rate && e("div", {
        class: this.ns.be("item", "rate")
      }, [e("rate-span", {
        attrs: {
          value: t.rate
        }
      })])]))])])]);
  }
}), et = S({
  name: "GwxnChartControl",
  props: {
    modelData: {
      type: B,
      required: !0
    },
    context: {
      type: Object,
      required: !0
    },
    params: {
      type: Object,
      default: () => ({})
    }
  },
  setup(t) {
    var E;
    const {
      proxy: k
    } = z(), g = H("chart"), l = J(k, t.modelData, t.context, t.params), c = ((E = l.model.source.getPSControlParam()) == null ? void 0 : E.ctrlParams) || {}, u = c.TYPE, x = c.TOTAL;
    let T = !0;
    const F = (n) => (Array.isArray(n) && x && n.length === 0 && (n.push({
      [x]: 100
    }), T = !1), n);
    l.registerLoadHook(F);
    const I = async (n) => {
      var b, O;
      const $ = n.tooltip;
      if ($) {
        const r = await l.service.getAllCodeListMap(l.context, l.params);
        $.formatter = (s) => {
          const a = document.createElement("div");
          return new G({
            el: a,
            render: (p) => p(V, {
              props: {
                params: s,
                ctrlParams: c,
                c: l,
                codeListMap: r
              }
            })
          }).$el;
        };
      }
      if (u === "line") {
        const r = n.xAxis;
        Array.isArray(r) && r.length && r.forEach((s) => {
          const a = s;
          a.max = (m) => m.max + 1;
        });
      }
      const o = n.series;
      if (!Array.isArray(o))
        return n;
      if (u === "custom") {
        const r = o.findIndex((a) => a.type === "pie");
        if (r !== -1) {
          let a = !0;
          const p = (O = (b = l.service.seriesList[r]) == null ? void 0 : b.valueField) == null ? void 0 : O.toLowerCase();
          p && l.items.every((C) => !C[p]) && (o.splice(r, 1), a = !1), a && (o[r] = N(o[r], {
            emphasis: {
              label: {
                formatter: (L) => {
                  var w;
                  const C = (w = L.value[0]) == null ? void 0 : w.replace("~", "-");
                  return `{value|${L.value[1]}}
{key|${C}}`;
                }
              }
            }
          }));
        }
        const s = o.findIndex((a) => a.type === "gauge");
        s !== -1 && (o[s] = N(o[s], {
          axisLabel: {
            formatter: (a) => a === 24 || a % 2 === 1 ? "" : `${a}`
          }
        }));
      }
      if (u === "radar") {
        const r = n.radar, s = o.find((a) => a.type === "radar");
        r && !Array.isArray(r) && Array.isArray(r.indicator) && s && Array.isArray(s.data) && s.data.length && (r.indicator = [...r.indicator.slice(0, 1), ...r.indicator.slice(1).reverse()], s.data[0] = [...s.data[0].slice(0, 1), ...s.data[0].slice(1).reverse()]);
      }
      if (x) {
        const r = n.graphic;
        if (Array.isArray(r) && r.length && T) {
          const s = l.items.reduce((a, m) => a + m[x], 0);
          r[0] = N(r[0], {
            style: {
              text: s
            }
          });
        }
        T || n.tooltip && Object.assign(n.tooltip, {
          show: !1
        });
      }
      return n;
    };
    return l.registerHook(I), {
      c: l,
      ns: g
    };
  },
  render() {
    if (this.c.complete)
      return e("control-layout", {
        attrs: {
          modelData: this.c.model
        }
      }, [e("div", {
        class: this.ns.b(),
        style: {
          width: this.c.width,
          height: this.c.height
        }
      }, [e("div", {
        attrs: {
          id: this.c.chartId
        },
        class: this.ns.b("content")
      }), this.c.items.length ? null : e("div", {
        class: this.ns.b("empty-content")
      }, ["暂无数据"])])]);
  }
});
export {
  et as default
};
