import { defineConfig } from 'vite';
import path from 'path';
import vue from '@vitejs/plugin-vue2';
import vueJsx from '@vitejs/plugin-vue2-jsx';
import eslint from 'vite-plugin-eslint';
import legacy from '@vitejs/plugin-legacy'; // ie11 开启此配置
// import { visualizer } from 'rollup-plugin-visualizer'; // 打包内容分析
import IBizVitePlugin from './vite-plugins/ibiz-vite-plugin';
import styleImport from 'vite-plugin-style-import';

// https://vitejs.dev/config/
export default defineConfig({
  base: './',
  resolve: {
    alias: {
      '@': path.resolve(__dirname, 'src'),
    },
  },
  build: {
    rollupOptions: {
      external: [
        'vue',
        'vue-router',
        'view-design',
        'async-validator',
        'dayjs',
        'axios',
        'pluralize',
        'qs',
        'ramda',
        'lodash-es',
        'qx-util',
        'echarts',
        '@riophae/vue-treeselect',
        '@ibiz/dynamic-model-api',
        '@ibiz-template/command',
        '@ibiz-template/core',
        '@ibiz-template/model',
        '@ibiz-template/service',
        '@ibiz-template/runtime',
        '@ibiz-template/controller',
        '@ibiz-template/vue-util',
      ],
    },
  },
  server: {
    proxy: {
      '/pms__sclpmswebapp': {
        target: 'http://172.16.103.158:30061',
        changeOrigin: true,
      },
      '/pms__portalwebapp': {
        target: 'http://172.16.103.158:30060',
        changeOrigin: true,
      },
      '/gsmgmt__gsweb': {
        target: 'http://172.16.103.158:30062',
        changeOrigin: true,
      },
      '/trainsys__web': {
        target: 'http://172.16.240.140:20086',
        changeOrigin: true,
      },
      '/jskq__kqwebapp': {
        target: 'http://172.16.103.134:30060',
        changeOrigin: true,
      },
    },
    cors: true,
    fs: {
      strict: false,
    },
  },
  css: {
    preprocessorOptions: {
      scss: {
        additionalData: '@import "@ibiz-template/theme/style/global.scss";',
      },
    },
  },
  plugins: [
    eslint({
      include: 'src/**/*.{ts,tsx,js,jsx}',
    }),
    vue(),
    vueJsx(),
    legacy({ targets: ['ie >= 11'], externalSystemJS: true }),
    IBizVitePlugin(),
    styleImport({
      libs: [
        {
          libraryName: 'element-ui',
          esModule: true,
          resolveStyle(name) {
            return `theme-chalk/${name}.css`;
          },
          resolveComponent(name) {
            return `element-ui/lib/${name}`;
          },
        },
      ],
    }),
    // visualizer(),
  ],
});
