import {
  ContainerPortletController,
  DashboardController,
  IPortletPartProvider,
  ListPortletController,
} from '@ibiz-template/controller';
import { ListPortletModel, PortletPartModel } from '@ibiz-template/model';

/**
 *  数据看板成员实体列表适配器
 *
 * @author lxm
 * @date 2022-10-19 15:10:44
 * @export
 * @class ListPortletProvider
 */
export class ListPortletProvider implements IPortletPartProvider {
  component: string = 'ListPortlet';

  async createController(
    portletModel: PortletPartModel,
    dashboard: DashboardController,
    parent?: ContainerPortletController,
  ): Promise<ListPortletController> {
    const c = new ListPortletController(
      portletModel as ListPortletModel,
      dashboard,
      parent,
    );
    await c.init();
    return c;
  }
}
