import { ExpViewEngine } from './exp-view-engine';

/**
 * 实体树导航视图界面引擎
 *
 * @export
 * @class TreeExpViewEngine
 * @extends {ViewEngine}
 */
export class TreeExpViewEngine extends ExpViewEngine {

    /**
     * 初始化引擎
     *
     * @param {*} options
     * @memberof TreeExpViewEngine
     */
    public init(options: any): void {
        this.expBar = options.treeexpbar;
        super.init(options);
    }

    /**
     * @description 视图销毁
     * @memberof TreeExpViewEngine
     */
    public destroyed() {
        super.destroyed();
        this.expBar = null;
    }

}