import { FormMDCtrlModel } from '@ibiz-template/model';
import {
  FormContainerController,
  FormController,
  FormMDCtrlController,
  IFormDetailProvider,
} from '@ibiz-template/controller';
/**
 * 表单多数据部件适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FormMDCtrlProvider
 * @implements {EditorProvider}
 */
export class FormMDCtrlProvider implements IFormDetailProvider {
  component: string = 'FormMDCtrl';

  async createController(
    detailModel: FormMDCtrlModel,
    form: FormController,
    parent: FormContainerController | undefined,
  ): Promise<FormMDCtrlController> {
    const c = new FormMDCtrlController(detailModel, form, parent);
    await c.init();
    return c;
  }
}
