import { IViewProvider } from '@ibiz-template/controller';
import { ModelUtil } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, PropType, ref } from 'vue';
import '@ibiz-template/theme/style/components/view-shell/view-shell.scss';
import { IModal } from '@ibiz-template/runtime';

export const ViewShell = defineComponent({
  name: 'ViewShell',
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modal: { type: Object as PropType<IModal> },
    modelPath: { type: String, required: true },
  },
  setup(props) {
    const provider = ref<IViewProvider>();
    ModelUtil.getViewModel(props.modelPath, props.context).then(
      async viewModel => {
        provider.value = await ibiz.register.view.get(viewModel.source);
      },
    );
    const ns = useNamespace('view-shell');
    return { ns, provider };
  },
  render(h) {
    if (this.provider) {
      return h('AppTransition', {}, [
        h(this.provider.component, {
          ...this.$vnode.data,
          on: this.$listeners,
        }),
      ]);
    }
    return (
      <div class={this.ns.b()}>
        <i-spin size='large' fix></i-spin>
      </div>
    );
  },
});
