import {
  ContainerPortletController,
  DashboardController,
  IPortletPartProvider,
  ToolbarPortletController,
} from '@ibiz-template/controller';
import { PortletPartModel, ToolbarPortletModel } from '@ibiz-template/model';

/**
 * 数据看板成员工具栏适配器
 *
 * @author lxm
 * @date 2022-10-19 15:10:44
 * @export
 * @class ToolbarPortletProvider
 */
export class ToolbarPortletProvider implements IPortletPartProvider {
  compName: string = 'PortletPart';

  async createController(
    portletModel: PortletPartModel,
    dashboard: DashboardController,
    parent?: ContainerPortletController,
  ): Promise<ToolbarPortletController> {
    const c = new ToolbarPortletController(
      portletModel as ToolbarPortletModel,
      dashboard,
      parent,
    );
    await c.init();
    return c;
  }
}
