import { FormGroupPanelModel } from '@ibiz-template/model';
import {
  FormContainerController,
  FormController,
  FormGroupPanelController,
  IFormDetailProvider,
} from '@ibiz-template/controller';
/**
 * 表单分组面板适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FormGroupPanelProvider
 * @implements {EditorProvider}
 */
export class FormGroupPanelProvider implements IFormDetailProvider {
  compName: string = 'FormGroupPanel';

  async createController(
    detailModel: FormGroupPanelModel,
    form: FormController,
    parent: FormContainerController | undefined,
  ): Promise<FormGroupPanelController> {
    const c = new FormGroupPanelController(detailModel, form, parent);
    await c.init();
    return c;
  }
}
