import { computed, defineComponent, ref } from 'vue';
import { IndexViewModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { Namespace } from '@ibiz-template/core';
import '@ibiz-template/theme/style/components/layout/app-layout/app-layout.scss';
import { renderCompatibleIE } from '@/ie-util';
import './app-layout.scss';

function renderLogo(ns: Namespace, model: IndexViewModel) {
  return (
    <div class={ns.e('logo')}>
      {model.appIconPath ? (
        <img class={ns.e('logo-img')} src={model.appIconPath}></img>
      ) : null}
      <div class={ns.e('logo-caption')}>{model.caption}</div>
    </div>
  );
}

export const AppLayout = defineComponent({
  name: 'AppLayout',
  props: {
    model: {
      type: IndexViewModel,
      required: true,
    },
    // 视图是否完成加载
    isComplete: {
      type: Boolean,
      default: false,
    },
    // 是否显示分页导航
    isShowTabPageExp: {
      type: Boolean,
      default: false,
    },
  },
  setup(props, { emit }) {
    const ns = useNamespace('layout');

    // 菜单收缩变化
    const collapseChange = ref(false);

    const collapseMenus = () => {
      collapseChange.value = !collapseChange.value;
      emit('onCollapseChange', collapseChange.value);
    };

    const isBlank = computed(() => props.model.source.blankMode === true);

    return { ns, collapseChange, isBlank, collapseMenus };
  },
  render() {
    return this.isComplete ? (
      <i-layout
        class={[
          this.ns.b(),
          this.isBlank ? this.ns.m('blank') : '',
          this.ns.is('collapse', this.collapseChange),
          this.ns.is('tab', this.isShowTabPageExp),
        ]}
      >
        <i-sider
          hide-trigger
          class={[
            this.ns.b('nav'),
            this.ns.is('collapse', this.collapseChange),
          ]}
          value={this.collapseChange}
        >
          {renderLogo(this.ns, this.model)}
          {this.$slots.menu}
        </i-sider>
        <i-layout class={[this.ns.b('content')]}>
          <i-header class={this.ns.b('header')}>
            <div class={this.ns.be('header', 'left')}>
              {renderLogo(this.ns, this.model)}
              <div class={this.ns.be('header', 'collapse-icon')}>
                {renderCompatibleIE(() => {
                  return !this.collapseChange ? (
                    <ion-icon
                      src={'./assets/img/menu-fold.svg'}
                      on-click={() => this.collapseMenus()}
                    />
                  ) : (
                    <ion-icon
                      src={'./assets/img/menu-unfold.svg'}
                      on-click={() => this.collapseMenus()}
                    />
                  );
                })}
              </div>
              {this.model.source.mainMenuAlign === 'TOP' ? (
                <i-menu
                  class={this.ns.be('header', 'menu')}
                  mode='horizontal'
                  active-name='1'
                ></i-menu>
              ) : null}
            </div>
            <div class={this.ns.be('header', 'right')}>
              <app-user />
            </div>
          </i-header>
          <i-content class={this.ns.be('content', 'main')}>
            {this.$slots.tabPageExp}
            {this.$slots.default}
          </i-content>
          {/* <i-footer class={this.ns.b('footer')}>Footer</i-footer> */}
        </i-layout>
      </i-layout>
    ) : null;
  },
});
