import { ViewType } from '@ibiz-template/model';
import { AppPortalViewProvider } from './app-portal-view-provider';
import { EditViewProvider } from './edit-view-provider';
import { EditView3Provider } from './edit-view3-provider';
import { GridViewProvider } from './grid-view-provider';
import { IndexViewProvider } from './index-view-provider';
import { ListExpViewProvider } from './list-exp-view-provider';
import { ListViewProvider } from './list-view-provider';
import { MPickupViewProvider } from './mpickup-view-provider';
import { OptViewProvider } from './opt-view-provider';
import { PickupGridViewProvider } from './pickup-grid-view-provider';
import { PickupViewProvider } from './pickup-view-provider';
import { TabExpViewProvider } from './tab-exp-view-provider';
import { TreeExpViewProvider } from './tree-exp-view-provider';
import { WFDynaActionViewProvider } from './wf-dyna-action-view-provider';
import { WFDynaEditView3Provider } from './wf-dyna-edit-view3-provider';
import { WFDynaStartViewProvider } from './wf-dyna-start-view-provider';
import { WFStepTraceViewProvider } from './wf-step-trace-view-provider';

/**
 * 预置默认的视图适配器
 *
 * @author lxm
 * @date 2022-10-26 11:10:46
 * @export
 * @returns {*}  {void}
 */
export function presetViewProvider(): void {
  const { view } = ibiz.register;
  if (!view) {
    return;
  }
  view.register(ViewType.APP_INDEX_VIEW, new IndexViewProvider());
  view.register(ViewType.DE_EDIT_VIEW, new EditViewProvider());
  view.register(ViewType.DE_EDIT_VIEW9, new EditViewProvider());
  view.register(ViewType.DE_GRID_VIEW, new GridViewProvider());
  view.register(ViewType.DE_GRID_VIEW9, new GridViewProvider());
  view.register(ViewType.DE_EDIT_VIEW3, new EditView3Provider());
  view.register(ViewType.DE_OPT_VIEW, new OptViewProvider());
  view.register(ViewType.DE_PICKUP_VIEW, new PickupViewProvider());
  view.register(ViewType.DE_MPICKUP_VIEW, new MPickupViewProvider());
  view.register(ViewType.DE_PICKUP_GRID_VIEW, new PickupGridViewProvider());
  view.register(ViewType.DE_WF_DYNA_EDIT_VIEW3, new WFDynaEditView3Provider());
  view.register(ViewType.DE_WF_DYNA_START_VIEW, new WFDynaStartViewProvider());
  view.register(
    ViewType.DE_WF_DYNA_ACTION_VIEW,
    new WFDynaActionViewProvider(),
  );
  view.register(ViewType.APP_WF_STEP_TRACE_VIEW, new WFStepTraceViewProvider());
  view.register(ViewType.APP_PORTAL_VIEW, new AppPortalViewProvider());
  // 导航
  view.register(ViewType.DE_TAB_EXP_VIEW, new TabExpViewProvider());
  view.register(ViewType.DE_LIST_EXP_VIEW, new ListExpViewProvider());
  view.register(ViewType.DE_LIST_VIEW, new ListViewProvider());
  view.register(ViewType.DE_TREE_EXP_VIEW, new TreeExpViewProvider());
}

export {
  EditViewProvider,
  IndexViewProvider,
  GridViewProvider,
  EditView3Provider,
  OptViewProvider,
  PickupViewProvider,
  MPickupViewProvider,
  PickupGridViewProvider,
  WFDynaEditView3Provider,
  WFDynaStartViewProvider,
  WFDynaActionViewProvider,
  WFStepTraceViewProvider,
  AppPortalViewProvider,
  ListExpViewProvider,
  ListViewProvider,
  TabExpViewProvider,
  TreeExpViewProvider,
};
