import { Component, Prop } from 'vue-property-decorator';
import { IPSAppDEMapExplorerView } from "@ibiz/dynamic-model-api";
import { ModelTool } from "ibiz-core";
import { AppDefaultViewLayout } from "../app-default-view-layout/app-default-view-layout";
import './app-default-mapexpview-layout.less';


@Component({})
export class AppDefaultMapExpViewLayout extends AppDefaultViewLayout {

	/**
	 * 实体地图导航视图模型对象
	 *
	 * @type {IPSAppDEMapExplorerView}
	 * @memberof AppDefaultMapExpViewLayout
	 */
	@Prop() public declare viewInstance: IPSAppDEMapExplorerView;

	/**
	 * 引擎初始化
	 *
	 * @param {*} [opts={}]
	 * @memberof AppDefaultMapExpViewLayout
	 */
	public engineInit(opts: any = {}) {
		const controls: any[] = this.containerModel.getPSControls() || [];
		const mapExpBar = ModelTool.findPSControlByType('MAPEXPBAR', controls);
		if (mapExpBar) {
			let engineOpts = Object.assign({
				view: this,
				p2k: '0',
				isLoadDefault: this.viewInstance?.loadDefault,
				keyPSDEField: this.appDeCodeName.toLowerCase(),
				majorPSDEField: this.appDeMajorFieldName.toLowerCase(),
				mapexpbar: (this.$refs[mapExpBar.name] as any).ctrl,
			}, opts);
			this.engine.init(engineOpts);
		}
	}

	/**
   * 计算目标部件数据
   *
   * @param {*} controlInstance
   * @return {*} 
   * @memberof AppDefaultMapExpViewLayout
   */
	public computeTargetCtrlData(controlInstance: any, args?: any) {
		const { targetCtrlName, targetCtrlParam, targetCtrlEvent } = super.computeTargetCtrlData(controlInstance, args);
		//	视图级参数
		Object.assign(targetCtrlParam.staticProps, { viewState: this.viewState, viewtag: this.viewtag, viewIsProxyMode: this.viewProxyMode });
		Object.assign(targetCtrlEvent, {
			closeView: ($event: any) => {
				this.$emit('view-event', { viewName: this.viewInstance.codeName, action: 'viewClosed', data: $event });
			}
		});
		return { targetCtrlName, targetCtrlParam, targetCtrlEvent };
	}
}