import { Prop, Component } from 'vue-property-decorator';
import { IPSAppDECalendarExplorerView } from "@ibiz/dynamic-model-api";
import { ModelTool } from "ibiz-core";
import { AppDefaultViewLayout } from "../app-default-view-layout/app-default-view-layout";
import './app-default-calendarexpview-layout.less';

@Component({})
export class AppDefaultCalendarExpViewLayout extends AppDefaultViewLayout {

    /**
     * 实体日历导航视图模型对象
     *
     * @type {IPSAppDECalendarExplorerView}
     * @memberof AppDefaultCalendarExpViewLayout
     */
    @Prop() public declare viewInstance: IPSAppDECalendarExplorerView;

    /**
     * 引擎初始化
     *
     * @param {*} [opts={}]
     * @memberof AppDefaultCalendarExpViewLayout
     */
    public engineInit(opts: any = {}) {
        const controls: any[] = this.containerModel.getPSControls() || [];
        const calendarExpBar = ModelTool.findPSControlByType('CALENDAREXPBAR', controls);
        if (calendarExpBar) {
            let engineOpts = Object.assign({
                view: this,
                p2k: '0',
                isLoadDefault: this.viewInstance?.loadDefault,
                keyPSDEField: this.appDeCodeName.toLowerCase(),
                majorPSDEField: this.appDeMajorFieldName.toLowerCase(),
                calendarexpbar: (this.$refs[calendarExpBar.name] as any).ctrl,
            }, opts);
            this.engine.init(engineOpts);
        }
    }

    /**
     * 计算目标部件数据
     *
     * @param {*} controlInstance
     * @return {*} 
     * @memberof AppDefaultCalendarExpViewLayout
     */
    public computeTargetCtrlData(controlInstance: any, args?: any) {
        const { targetCtrlName, targetCtrlParam, targetCtrlEvent } = super.computeTargetCtrlData(controlInstance, args);
        //	视图级参数
        Object.assign(targetCtrlParam.staticProps, { viewState: this.viewState, viewtag: this.viewtag, viewIsProxyMode: this.viewProxyMode });
        Object.assign(targetCtrlEvent, {
            closeView: ($event: any) => {
                this.$emit('view-event', { viewName: this.viewInstance.codeName, action: 'viewClosed', data: $event });
            }
        });
        return { targetCtrlName, targetCtrlParam, targetCtrlEvent };
    }

}