import { FormTabPageController } from '@ibiz-template/controller';
import { FormTabPageModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, VNode } from 'vue';

export default defineComponent({
  props: {
    modelData: {
      type: FormTabPageModel,
      required: true,
    },
    controller: {
      type: FormTabPageController,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('form-tab-page');
    return { ns };
  },
  render() {
    const defaultSlots: VNode[] = this.$slots.default || [];
    defaultSlots.forEach(item => {
      const data = item.data;
      if (data) {
        data.class = { [this.ns.b('child')]: true };
      }
    });
    return (
      <app-row
        class={[this.ns.b(), this.ns.m(this.modelData.modelClass)]}
        layout={this.modelData.source.getPSLayout()}
      >
        {defaultSlots.map(slot => {
          const opts = slot.componentOptions!;
          // eslint-disable-next-line @typescript-eslint/no-explicit-any
          const props = (opts.propsData || {}) as Record<string, any>;
          return (
            <app-col
              layoutPos={props.modelData.source.getPSLayoutPos()}
              controller={props.controller.layoutController}
            >
              {slot}
            </app-col>
          );
        })}
      </app-row>
    );
  },
});
