import { defineComponent } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';

export const AppGridEditItem = defineComponent({
  name: 'AppGridEditItem',
  props: {
    required: {
      type: Boolean,
    },
    error: {
      type: String || null,
    },
  },
  setup() {
    const ns = useNamespace('grid-edit-item');
    return { ns };
  },
  render() {
    return (
      <div class={this.ns.b()}>
        {!this.error ? (
          this.$slots.default
        ) : (
          <i-tooltip
            content={this.error}
            transfer
            transfer-class-name='grid-error'
            placement='top'
            style='border: 1px solid red'
          >
            {this.$slots.default}
          </i-tooltip>
        )}
      </div>
    );
  },
});
export default AppGridEditItem;
