/* eslint-disable @typescript-eslint/no-explicit-any */
import {
  GridFieldColumnController,
  GridRowController,
} from '@ibiz-template/controller';
import { computed, defineComponent, ref, Ref, watch } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/widgets/grid/grid-field-column.scss';

export const GridFieldColumn = defineComponent({
  name: 'GridFieldColumn',
  props: {
    controller: {
      type: GridFieldColumnController,
      required: true,
    },
    row: {
      type: GridRowController,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('grid-field-column');

    const c = props.controller;

    const codeList = props.controller.model.source.getPSAppCodeList();

    /**
     * 单元格点击事件
     *
     * @author lxm
     * @date 2022-09-28 18:09:27
     * @param {MouseEvent} event
     */
    const onCellClick = (event: MouseEvent) => {
      if (props.controller.isLinkColumn) {
        // 阻止触发行点击
        event.stopPropagation();
        props.controller.openLinkView(props.row, event);
      } else if (props.controller.hasAction) {
        // 阻止触发行点击
        event.stopPropagation();
        props.controller.triggerAction(props.row, event);
      }
    };
    const enableGridRowBreak = computed(() => {
      if (c?.grid?.controlParams?.ENABLEGRIDROWBREAK) {
        return c.grid.controlParams.ENABLEGRIDROWBREAK === 'TRUE';
      }
      return (
        (ibiz.env.enableGridRowBreak as any) === 'TRUE' ||
        ibiz.env.enableGridRowBreak === true
      );
    });

    const alignStyle = computed(() => {
      let justContent = '';
      switch (props.controller.model.align) {
        case 'LEFT':
          justContent = 'flex-start';
          break;
        case 'RIGHT':
          justContent = 'flex-end';
          break;
        default:
          justContent = 'center';
          break;
      }
      return ns.cssVarBlock({ 'justify-content': justContent });
    });

    const CustomHtml: Ref<string | undefined> = ref('');

    if (c.isCustomCode) {
      watch(
        () => props.row.data,
        async () => {
          CustomHtml.value = await props.controller.getCustomHtml(
            props.row.data,
          );
        },
        {
          deep: true,
          immediate: true,
        },
      );
    }

    return {
      ns,
      alignStyle,
      codeList,
      CustomHtml,
      onCellClick,
      enableGridRowBreak,
    };
  },
  render() {
    const c = this.controller;
    const fieldValue = this.row.data[this.controller.model.codeName];
    let content = null;
    if (c.isCustomCode) {
      content = <span class={this.ns.e('script')}>{this.CustomHtml}</span>;
    } else if (this.codeList) {
      content = (
        <code-list
          class={[
            this.ns.e('text'),
            this.ns.is('enablebreak', this.enableGridRowBreak),
          ]}
          codeListItems={c.codeListItems}
          codeList={this.codeList}
          value={fieldValue}
          textSeparator={c.model.source?.textSeparator}
        ></code-list>
      );
    } else {
      content = (
        <span
          class={[
            this.ns.e('text'),
            this.ns.is('enablebreak', this.enableGridRowBreak),
          ]}
        >
          {fieldValue}
          {fieldValue != null && c.model.unitName}
        </span>
      );
    }
    return (
      <div
        class={[
          this.ns.b(),
          c.clickable && this.ns.m('clickable'),
          this.ns.m(c.model.codeName),
        ]}
        style={this.alignStyle}
        onClick={this.onCellClick}
      >
        {content}
      </div>
    );
  },
});
export default GridFieldColumn;
