export interface AppDrawerOptions {
  /**
   * 抽屉宽度
   * 左、右方向时可用。当其值不大于 100 时以百分比显示，大于 100 时为像素
   *
   * @author lxm
   * @date 2022-09-12 20:09:20
   * @type {string | number}
   */
  width?: string | number;
  /**
   * 抽屉高度
   * 上、下方向时可用。当其值不大于 100 时以百分比显示，大于 100 时为像素
   *
   * @author lxm
   * @date 2022-09-12 20:09:22
   * @type {string | number}
   */
  height?: string | number;

  /**
   * 抽屉的方向
   *
   * @author lxm
   * @date 2022-09-15 14:09:13
   * @type {('left' | 'right' | 'top' | 'bottom')}
   */
  placement?: 'left' | 'right' | 'top' | 'bottom';
}
