import Router from 'vue-router';
import { Environment } from '@ibiz-template/core';
import { safeRedirect } from '@ibiz-template/runtime';
import { AuthGuard } from '../guard';
import RouterShell from '@/components/router-shell/router-shell';
import appRedirectView from '@/views/app-redirect-view/app-redirect-view';
// import loginView from '../components/login-view/app-login-view/app-login-view';
import loginView from '../views/login-view/login-view';
import _404View from '../views/404-view/404-view';
import _403View from '../views/403-view/403-view';
import todoRedirect from '@/views/todo-redirect/todo-redirect';

const placeholder = Environment.routePlaceholder;
// 参数正则，占位符或者以等号相隔的参数键值对
const paramReg = `[^/]+=[^/]+|${placeholder}`;
// 视图正则，非=/的字符串
const viewReg = `[^=/]+`;

// 兼容ie
const originalPush = Router.prototype.push;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
Router.prototype.push = function push(location: any) {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const result: any = originalPush.call(this, location);
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  return result.catch((err: any) => err);
};

const router = new Router({
  routes: [
    {
      path: '/',
      redirect: `/${placeholder}/index/${placeholder}`,
    },
    {
      path: '/login',
      name: 'loginView',
      beforeEnter: async (_to, _from, next) => {
        if (ibiz.env.noAuthRedirectUrl) {
          safeRedirect(ibiz.env.noAuthRedirectUrl, { type: '_self' });
        }
        if (ibiz.env.disabledLogin) {
          next(false);
        } else {
          next();
        }
      },
      component: loginView,
    },
    {
      path: '/404',
      name: '404View1',
      component: _404View,
    },
    {
      path: '/403',
      name: '403View1',
      component: _403View,
    },
    {
      path: '/appredirectview',
      name: 'appRedirectView',
      beforeEnter: async (_to, _from, next) => {
        const authority = await AuthGuard();
        if (authority) {
          next();
        } else {
          next(false);
        }
      },
      component: appRedirectView,
    },
    {
      path: '/todoredirect',
      name: 'todoRedirect',
      beforeEnter: async (_to, _from, next) => {
        const authority = await AuthGuard();
        if (authority) {
          next();
        } else {
          next(false);
        }
      },
      component: todoRedirect,
    },
    {
      path: `/:appContext(${paramReg})/:view1(${viewReg})/:params1(${paramReg})`,
      props: {
        level: 1,
      },
      beforeEnter: async (_to, _from, next) => {
        const authority = await AuthGuard();
        if (authority) {
          next();
        } else {
          next(false);
        }
      },
      component: RouterShell,
      children: [
        {
          path: '404',
          name: '404View2',
          component: _404View,
        },
        {
          path: '403',
          name: '403View2',
          component: _403View,
        },
        {
          path: `:view2(${viewReg})/:params2(${paramReg})`,
          props: {
            level: 2,
          },
          component: RouterShell,
          children: [
            {
              path: '404',
              name: '404View3',
              component: _404View,
            },
            {
              path: '403',
              name: '403View3',
              component: _403View,
            },
            {
              path: `:view3(${viewReg})/:params3(${paramReg})`,
              props: {
                level: 3,
              },
              component: RouterShell,
              children: [
                {
                  path: '404',
                  name: '404View4',
                  component: _404View,
                },
                {
                  path: '403',
                  name: '403View4',
                  component: _403View,
                },
                {
                  path: `:view4(${viewReg})/:params4(${paramReg})`,
                  props: {
                    level: 4,
                  },
                  component: RouterShell,
                },
                {
                  path: '*',
                  redirect: { name: '404View4' },
                },
              ],
            },
            {
              path: '*',
              redirect: { name: '404View3' },
            },
          ],
        },
        {
          path: '*',
          redirect: { name: '404View2' },
        },
      ],
    },
    {
      path: '/*',
      redirect: { name: '404View1' },
    },
  ],
});

export default router;
