import { defineComponent } from 'vue';
import {
  getGridDatePickerProps,
  getGridEditorEmits,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridDatePicker = defineComponent({
  name: 'IBizGridDatePicker',
  props: getGridDatePickerProps(),
  emits: getGridEditorEmits(),
  setup(props, { emit }) {
    const ns = useNamespace('grid-date-picker');
    const { isInfoMode, componentRef, autoFocus, onOperateChange, onChange } =
      useGridCellEditor(props, { emit });

    return {
      ns,
      isInfoMode,
      autoFocus,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <grid-editor
        disabled={this.disabled}
        readonly={this.readonly}
        ref='componentRef'
        class={`${this.ns.b()}`}
      >
        {h('IBizDatePicker', {
          props: {
            ...this.$props,
            readonly: this.isInfoMode,
            disabled: this.disabled,
            autoFocus: this.autoFocus,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </grid-editor>
    );
  },
});
