import { IModal } from '@ibiz-template/runtime';
import {
  useNamespace,
  usePickupView2Controller,
} from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType, VNode } from 'vue';
import '@ibiz-template/theme/style/components/views/pickup-view2/pickup-view2.scss';

export const PickupView2 = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams>, default: () => ({}) },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
    noLoadDefault: { type: Boolean, required: false },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = usePickupView2Controller(proxy, props.modelPath);
    const ns = useNamespace('view-depickupview2');
    return { c, ns };
  },
  render(h) {
    let panelComponent = null;
    let treeComponent: VNode | null = null;

    if (this.c.complete) {
      const { tree, pickupViewPanel } = this.c.model;
      if (this.c.providers[tree.name]) {
        treeComponent = h(this.c.providers[tree.name].component, {
          props: {
            modelData: tree,
            context: this.c.context,
            params: this.c.params,
            isSelectFirstDefault: true,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit('tree'),
          },
        });
      }
      if (this.c.providers[pickupViewPanel.name]) {
        panelComponent = h(this.c.providers[pickupViewPanel.name].component, {
          props: {
            modelData: pickupViewPanel,
            context: this.c.navPanelParams.context,
            params: this.c.navPanelParams.params,
            noLoadDefault: true,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(pickupViewPanel.name),
          },
        });
      }
    }
    return (
      <view-base controller={this.c}>
        <div class={this.ns.b('container')}>
          <div class={this.ns.b('left')}>{treeComponent}</div>
          <div class={this.ns.b('right')}>{panelComponent}</div>
        </div>
      </view-base>
    );
  },
});
