import { IModal, ViewMode } from '@ibiz-template/runtime';
import { useRouteKey, useTreeExpViewController } from '@ibiz-template/vue-util';
import {
  defineComponent,
  getCurrentInstance,
  h,
  PropType,
  ref,
  Ref,
  toRef,
  VNode,
  watch,
} from 'vue';

export const TreeExpView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    srfnav: String,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
    noLoadDefault: { type: Boolean, required: false },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    // const route = useRoute(proxy);
    const c = useTreeExpViewController(proxy, props.modelPath);
    const routeViewKey: Ref<string> = ref('');

    // 绘制界面需要的响应变量
    const defaultSelectKeys: Ref<string[]> = ref([]);

    if (c.context.isRouter) {
      // created生命周期后处理默认的路由回显
      c.nerve.self.evt.on('created', () => {
        // 路由模式下导航视图的key
        c.currentNavKey = props.srfnav || '';
        // 第一次打开的默认选中树节点
        if (c.currentNavKey) {
          defaultSelectKeys.value.push(c.currentNavKey);
        }
        // 监听并变更routeViewKey
        useRouteKey(toRef(c, 'currentNavKey'), proxy, routeViewKey);
      });
    }

    const keyHistory = ref<string[]>([]);
    watch(routeViewKey, (newVal, oldVal) => {
      if (newVal && newVal !== oldVal && !keyHistory.value.includes(newVal)) {
        keyHistory.value.push(newVal);
      }
    });

    return { c, defaultSelectKeys, routeViewKey, keyHistory };
  },
  render() {
    const { currentNavKey, navViewParams } = this.c;
    let treeComponent: VNode | null = null;
    let expBarModel = null;

    if (this.c.complete) {
      const { tree } = this.c.model;
      expBarModel = this.c.model.treeExpBar;
      if (this.c.providers[tree.name]) {
        treeComponent = h(this.c.providers[tree.name].component, {
          props: {
            modelData: tree,
            context: this.c.context,
            params: this.c.params,
            defaultSelectKeys: this.defaultSelectKeys,
            isSelectFirstDefault: true,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit('tree'),
          },
        });
      }
    }
    return (
      <exp-view-base
        controller={this.c}
        expBarModel={expBarModel}
        scopedSlots={{
          default: () => treeComponent,
          expView: () => {
            if (!currentNavKey) {
              return;
            }
            if (!this.c.context.isRouter) {
              // 非路由模式下绘制嵌入视图
              return h('ViewShell', {
                attrs: {
                  context: navViewParams[currentNavKey].context,
                  params: navViewParams[currentNavKey].params,
                  modal: { mode: ViewMode.EMBED },
                  modelPath: navViewParams[currentNavKey].modelPath,
                },
                key: currentNavKey,
              });
            }

            // 路由模式下绘制
            if (this.routeViewKey) {
              return <router-view key={this.routeViewKey}></router-view>;
            }
            return null;
          },
        }}
      ></exp-view-base>
    );
  },
});
